version 14
#delimit;
log using "R:\Gagnon\Asia New Mediocre\Asia Phillips Blog.txt", replace text;
clear;
clear mata;
clear matrix;
set more off;
*set maxvar 32767, permanently;
cd "R:\Gagnon\Asia New Mediocre";

import excel "R:\Gagnon\Asia New Mediocre\Phillips 20171115.xlsx", sheet("Sheet1") firstrow clear;
*Manual updating from Haver, November 15, 2017 for 2017q2 and 2017q3;
*Note PGDP revisions starting in 2016Q1, other series have no revisions;
gen double time = quarterly(quarter, "YQ");
format time %tq;
sort time;
tsset time;
drop dpgdp;

replace gap = -gap;
gen d4pgdp = 100*(pgdp-L4.pgdp)/L4.pgdp;
gen dpsurp2y = d4pgdp-L8.survey;
tssmooth ma d4pgdpma = d4pgdp, w(11 1 0);
gen dd4pgdpma = d4pgdp-L4.d4pgdpma;
gen d4pcex = 100*(pcexfe-L4.pcexfe)/L4.pcexfe;
tssmooth ma d4pcexma = d4pcex, w(11 1 0);
gen dd4pcexma = d4pcex-L4.d4pcexma;

scatter dpsurp2y L4.gap if L4.d4pgdp<3&time>=tq(1955q1), xlab(-5(1)3) ylab(-6(2)8) xtitle("Employment Gap") ytitle("Surprise in Inflation") 
        title("Inflation < 3%") xline(0) yline(0) mcolor(gs11) ttext(0.03 -0.16 "2017Q3", color(black) size(small)) saving(PClsurp2low.gph, replace);
scatter dpsurp2y L4.gap if L4.d4pgdp>3&time>=tq(1955q1), xlab(-5(1)3) ylab(-6(2)8) xtitle("Employment Gap") ytitle("Surprise in Inflation") 
        title("Inflation > 3%") xline(0) yline(0) mcolor(gs11) saving(PClsurp2high.gph, replace);
scatter dd4pgdpma L4.gap if L4.d4pgdp<3&time>=tq(1955q1), xlab(-5(1)3) ylab(-6(2)8) xtitle("Employment Gap") ytitle("Change in Inflation") 
        title("Inflation < 3%") xline(0) yline(0) mcolor(gs11) ttext(0.40 -0.16 "2017Q3", color(black) size(small)) saving(PCldiffmalow.gph, replace);
scatter dd4pgdpma L4.gap if L4.d4pgdp>3&time>=tq(1955q1), xlab(-5(1)3) ylab(-6(2)8) xtitle("Employment Gap") ytitle("Change in Inflation") 
        title("Inflation > 3%") xline(0) yline(0) mcolor(gs11) saving(PCldiffmahigh.gph, replace);
scatter dd4pcexma L4.gap if L4.d4pcex<3&time>=tq(1955q1), xlab(-5(1)3) ylab(-4(2)8) xtitle("Employment Gap") ytitle("Change in Inflation") 
        title("Inflation < 3%") xline(0) yline(0) mcolor(gs11) ttext(-0.18 -0.16 "2017Q3", color(black) size(small)) saving(PCpcexlow.gph, replace);
scatter dd4pcexma L4.gap if L4.d4pcex>3&time>=tq(1955q1), xlab(-5(1)3) ylab(-4(2)8) xtitle("Employment Gap") ytitle("Change in Inflation") 
        title("Inflation > 3%") xline(0) yline(0) mcolor(gs11) saving(PCpcexhigh.gph, replace);

*graph combine PClsurp2low.gph PClsurp2high.gph, rows(2) xcommon ycommon saving(PClsurp2both, replace);
*graph combine PClsurp2low.gph PClsurp2high.gph PCldiffmalow.gph PCldiffmahigh.gph, rows(2) xcommon ycommon saving(PCgaps.gph, replace);

scatter dd4pgdpma L4.caputil if L4.d4pgdp<3, xlab(65(5)90) ylab(-6(2)8) xtitle("Capacity Utilization") ytitle("Change in Inflation") 
        title("Inflation < 3%") xline(80.3) yline(0) mcolor(gs11) ttext(0.40 75.8 "2017Q3", color(black) size(small)) saving(PCldiffmalowcu.gph, replace);
scatter dd4pgdpma L4.caputil if L4.d4pgdp>3, xlab(65(5)90) ylab(-6(2)8) xtitle("Capacity Utilization") ytitle("Change in Inflation") 
        title("Inflation > 3%") xline(80.3) yline(0) mcolor(gs11) saving(PCldiffmahighcu.gph, replace);
scatter dpsurp2y L4.caputil if L4.d4pgdp<3, xlab(65(5)90) ylab(-6(2)8) xtitle("Capacity Utilization") ytitle("Surprise in Inflation") 
        title("Inflation < 3%") xline(80.3) yline(0) mcolor(gs11) ttext(0.03 75.8 "2017Q3", color(black) size(small)) saving(PClsurp2lowcu.gph, replace);
scatter dpsurp2y L4.caputil if L4.d4pgdp>3, xlab(65(5)90) ylab(-6(2)8) xtitle("Capacity Utilization") ytitle("Surprise in Inflation") 
        title("Inflation > 3%") xline(80.3) yline(0) mcolor(gs11) saving(PClsurp2highcu.gph, replace);
*graph combine PClsurp2lowcu.gph PClsurp2highcu.gph, rows(2) xcommon ycommon saving(PClsurp2bothcu, replace);
*graph combine PClsurp2lowcu.gph PClsurp2highcu.gph PCldiffmalowcu.gph PCldiffmahighcu.gph, rows(2) xcommon ycommon saving(PCcaputil, replace);
*graph combine PClsurp2low.gph PClsurp2high.gph PCldiffmalowcu.gph PCldiffmahighcu.gph, rows(2) ycommon saving(PCblog, replace);
*graph combine PCldiffmalow.gph PCldiffmahigh.gph, rows(1) ycommon saving(PCbloga, replace);
*graph combine PClsurp2lowcu.gph PClsurp2highcu.gph, rows(1) ycommon saving(PCblogb, replace);
graph combine PCpcexlow.gph PCpcexhigh.gph, rows(1) ycommon saving(PCblogc, replace);


log close;









 


